﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.Models;
using VA.PPMS.Context;

namespace PpmsDataWebService.Mappers
{
    public class ProviderPrivilegesMap
    {
        public static async Task<IQueryable<ProviderPrivilege>> MapProviderPrivileges(List<ppms_providerprivilege> ppmsProviderPrivileges, string mapRelatedType, PpmsContext context)
        {
            var providerPrivileges = new List<ProviderPrivilege> {};
            foreach (var ppmsProviderPrivilege in ppmsProviderPrivileges)
            {
                var providerPrivilege = new ProviderPrivilege
                {
                    Name = ppmsProviderPrivilege.ppms_name,
                    Comment = ppmsProviderPrivilege.ppms_Comment
                };
                if (ppmsProviderPrivilege.ppms_expirationdate != null)
                {
                    providerPrivilege.ExpirationDate = ppmsProviderPrivilege.ppms_expirationdate.ToString();
                }

                if (mapRelatedType.Contains("?$expand=Provider"))
                    mapRelatedType = "Provider";
                if (mapRelatedType.Contains("?$expand=PrivilegeLocation"))
                    mapRelatedType = "PrivilegeLocation";

                //Map Related Types Switch 
                switch (mapRelatedType)
                {
                    case "Provider":
                        //Lookup and Map the Single Provider
                        var ppmsProvider =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderPrivilege.ppms_ProviderId.Id);
                        var ppmsProviderList = new List<Account> {ppmsProvider};
                        providerPrivilege.Provider =
                            await ProviderMap.MapProviders(ppmsProviderList, "None");
                        break;
                    case "PrivilegeLocation":
                        //Lookup and Map the Single Specialty
                        var ppmsCareSite =
                            context.ppms_caresiteSet.FirstOrDefault(
                                i => i.Id == ppmsProviderPrivilege.ppms_CareSite.Id);
                        var ppmsCareSiteList = new List<ppms_caresite> { ppmsCareSite };
                        providerPrivilege.PrivilegeLocation =
                            await CareSiteMap.MapCareSites(ppmsCareSiteList, "None", context);
                        break;

                    default:
                        break;
                }

                providerPrivileges.Add(providerPrivilege);
            }

            return providerPrivileges.AsQueryable();            
        }      
    }
}